require "API/DST_API"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Fitness"

--------------------------------------------------------------------------------
-- Per-level tables (10 entries = L1..L10). Percentages unless stated otherwise.
--------------------------------------------------------------------------------

-- Core stamina dynamics
local _ENDURANCE_REGEN_BONUS = { 2,  4,  6,  8, 10, 12, 14, 16, 18, 20 }  -- +% endurance regen
local _EXERTION_GAIN_REDUCE  = { 5, 10, 15, 20, 25, 30, 35, 40, 45, 50 }  -- -% exertion gain

-- Combat & movement interactions (targeting ~0→20% by L10)
-- Note: last entry jumps to 20 to match wiki's L10 figure.
local _BLOCK_CHANCE_PLUS     = { 0,  2,  4,  6,  8, 10, 12, 14, 16, 20 }  -- +% block chance
local _ATTACK_SPEED_PLUS     = { 0,  2,  4,  6,  8, 10, 12, 14, 16, 20 }  -- +% attack speed
local _TRIP_CHANCE_REDUCE    = { 0,  2,  4,  6,  8, 10, 12, 14, 16, 20 }  -- -% trip chance
local _CLIMB_TALL_BONUS      = { 0,  2,  4,  6,  8, 10, 12, 14, 16, 20 }  -- +% tall fence climb chance

-- Multipliers (shown as "% of baseline"; lower fatigue/loss is better)
local _FATIGUE_GAIN_MULT     = { 100, 95, 92, 89, 87, 85, 83, 81, 79, 75 }   -- %
-- Merge Athletic "actual" values for L9–L10 so we only show obtainable in-game values
local _END_LOSS_MULT         = { 90, 80, 75, 70, 65, 60, 57, 53, 36.8, 34.4 } -- %
local _END_REGEN_MULT        = { 70, 80, 90, 100, 110, 120, 130, 140, 150, 160 }  -- %

--------------------------------------------------------------------------------
-- Computed lines — same pattern as Strength.lua (inline clamp to 1..10)
--------------------------------------------------------------------------------
ST.addContributor("Fitness", function(ctx)
    local lvl = ctx.getLevel()

    -- Header (parity with other skills)
    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))

    -- Core stamina dynamics
    ctx.add(ST.getText("IGUI_DST_Fitness_val_Regen",    tostring((_ENDURANCE_REGEN_BONUS[lvl] or "-"))))
    ctx.add(ST.getText("IGUI_DST_Fitness_val_Exertion", tostring((_EXERTION_GAIN_REDUCE[lvl]  or "-"))))

    -- Extra effects (per wiki)
    ctx.add(ST.getText("IGUI_DST_Fitness_val_Block",       tostring((_BLOCK_CHANCE_PLUS[lvl]  or "-"))))
    ctx.add(ST.getText("IGUI_DST_Fitness_val_AttackSpeed", tostring((_ATTACK_SPEED_PLUS[lvl]  or "-"))))
    ctx.add(ST.getText("IGUI_DST_Fitness_val_Trip",        tostring((_TRIP_CHANCE_REDUCE[lvl] or "-"))))
    ctx.add(ST.getText("IGUI_DST_Fitness_val_ClimbTall",   tostring((_CLIMB_TALL_BONUS[lvl]   or "-"))))

    ctx.addHeader(ST.getText("IGUI_DST_Multiplier_hdr"))
    -- Multipliers (lower is better for fatigue/loss; higher better for regen)
    ctx.add(ST.getText("IGUI_DST_Fitness_val_FatigueMult",        tostring((_FATIGUE_GAIN_MULT[lvl]    or "-"))))
    ctx.add(ST.getText("IGUI_DST_Fitness_val_EnduranceLossMult",  tostring((_END_LOSS_MULT[lvl]        or "-"))))
    ctx.add(ST.getText("IGUI_DST_Fitness_val_EnduranceRegenMult", tostring((_END_REGEN_MULT[lvl]       or "-"))))

    --------------------------------------------------------------------------------
    -- Trait transitions (Unfit/Out of Shape → cleared → Fit → Athletic)
    --------------------------------------------------------------------------------

    local T_Unfit    = ST.getText("UI_trait_unfit")
    local T_OoS      = ST.getText("UI_trait_outofshape")
    local T_Fit      = ST.getText("UI_trait_fit")
    local T_Athletic = ST.getText("UI_trait_athletic")

    local active =  { color = ST.COLORS.leafgreen }
    local removed = { color = ST.COLORS.orange }
    local gained =  { color = ST.COLORS.yellow }

    ctx.addSeparator()

    if lvl == 1 then
        ctx.add(ST.getText("IGUI_DST_Trait_Active", T_Unfit), active)

    elseif lvl == 2 then
        ctx.add(ST.getText("IGUI_DST_Trait_Removed", T_Unfit), removed)
        ctx.add(ST.getText("IGUI_DST_Trait_Gained", T_OoS), gained)

    elseif lvl == 3 or lvl == 4 then
        ctx.add(ST.getText("IGUI_DST_Trait_Active", T_OoS), active)

    elseif lvl == 5 then
        ctx.add(ST.getText("IGUI_DST_Trait_Cleared"), active)

    elseif lvl == 6 then
        ctx.add(ST.getText("IGUI_DST_Trait_Gained", T_Fit), gained)

    elseif lvl == 7 or lvl == 8 then
        ctx.add(ST.getText("IGUI_DST_Trait_Active", T_Fit), active)

    elseif lvl == 9 then
        ctx.add(ST.getText("IGUI_DST_Trait_Removed", T_Fit), removed)
        ctx.add(ST.getText("IGUI_DST_Trait_Gained", T_Athletic), gained)

    elseif lvl == 10 then
        ctx.add(ST.getText("IGUI_DST_Trait_Active", T_Athletic), active)
    end
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)